DROP TRIGGER PATS.GENERATE_BOILERPLATE_TEXT_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_BOILERPLATE_TEXT_ID BEFORE
INSERT ON PATS.BOILERPLATE_RESOLUTION_TEXT FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
    SELECT pats.boilerplate_text_seq.NEXTVAL
      INTO :new.id
      FROM DUAL;
 END IF;
END generate_boilerplate_text_id;
/
DROP TRIGGER PATS.PAD_LOCATION_TRG;

CREATE OR REPLACE TRIGGER PATS.PAD_LOCATION_TRG
BEFORE INSERT on PATS.PAD_LOCATION
FOR EACH ROW
BEGIN
SELECT PAD_LOCATION_SEQ.NEXTVAL
INTO :NEW.ID
FROM DUAL;
END pad_location_trg;
/
DROP TRIGGER PATS.GENERATE_CC_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_CC_ID BEFORE
INSERT ON PATS.CONGRESSIONAL_CONTACT FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
    SELECT pats.congressional_contact_seq.NEXTVAL
      INTO :new.id
      FROM DUAL;
 END IF;
END generate_cc_id;
/
DROP TRIGGER PATS.GENERATE_CONTACTING_ENTITY_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_CONTACTING_ENTITY_ID BEFORE
INSERT ON PATS.CONTACTING_ENTITY FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.contacting_entity_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
 END generate_contacting_entity_id;
/
DROP TRIGGER PATS.GENERATE_COMP_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_COMP_ID BEFORE
INSERT ON PATS.COMPS FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
    SELECT pats.comps_seq.NEXTVAL
      INTO :new.id
      FROM DUAL;
 END IF;
END generate_comp_id;
/
DROP TRIGGER PATS.GENERATE_HOSPITAL_LOCATION_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_HOSPITAL_LOCATION_ID BEFORE
INSERT ON PATS.HOSPITAL_LOCATION FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.hospital_location_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
 END generate_hospital_location_id;
/
DROP TRIGGER PATS.GENERATE_NOTIFICATION_DET_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_NOTIFICATION_DET_ID BEFORE
INSERT ON PATS.NOTIFICATION_DETAIL FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.notification_detail_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
 END generate_notification_det_id;
/
DROP TRIGGER PATS.GENERATE_PATIENT_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_PATIENT_ID BEFORE
INSERT ON PATS.PATS_PATIENT FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.pats_patient_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
 END generate_patient_id;
/
DROP TRIGGER PATS.GENERATE_PATS_ROLLUP_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_PATS_ROLLUP_ID BEFORE
INSERT ON PATS.PATS_ROLLUP_NATL_DATA FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
    SELECT pats_rollup_to_natl_seq.NEXTVAL
      INTO :new.id
      FROM DUAL;
 END IF;
END generate_pats_rollup_id;
/
DROP TRIGGER PATS.GENERATE_ROC_ISSUE_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_ROC_ISSUE_ID
    BEFORE
INSERT ON PATS.ROC_ISSUE FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.roc_issue_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
END GENERATE_ROC_ISSUE_ID;
/
DROP TRIGGER PATS.UPDATE_UPPERCASE_FSS_NAME;

CREATE OR REPLACE TRIGGER PATS.UPDATE_UPPERCASE_FSS_NAME BEFORE
INSERT
OR UPDATE ON PATS.FACILITY_SERVICE_OR_SECTION FOR EACH ROW
BEGIN
  IF (:old.service_or_section_name IS NULL) OR (:old.service_or_section_name != :new.service_or_section_name) THEN
   :new.upper_case_name := UPPER(:new.service_or_section_name);
  END IF;
 END update_uppercase_fss_name;
/
DROP TRIGGER PATS.UPDATE_UPPERCASE_COMP_NAME;

CREATE OR REPLACE TRIGGER PATS.UPDATE_UPPERCASE_COMP_NAME BEFORE
INSERT
OR UPDATE ON PATS.COMPS FOR EACH ROW
BEGIN
  IF (:old.comp_name IS NULL) OR (:old.comp_name != :new.comp_name) THEN
   :new.upper_case_name := UPPER(:new.comp_name);
  END IF;
 END update_uppercase_comp_name;
/
DROP TRIGGER PATS.UPDATE_UPPERCASE_CE_NAME;

CREATE OR REPLACE TRIGGER PATS.UPDATE_UPPERCASE_CE_NAME BEFORE
INSERT
OR UPDATE ON PATS.CONTACTING_ENTITY FOR EACH ROW
BEGIN
  IF (:old.contacting_entity_name IS NULL) OR (:old.contacting_entity_name != :new.contacting_entity_name) THEN
   :new.upper_case_name := UPPER(:new.contacting_entity_name);
  END IF;
 END update_uppercase_ce_name;
/
DROP TRIGGER PATS.UPDATE_UPPERCASE_CC_NAME;

CREATE OR REPLACE TRIGGER PATS.UPDATE_UPPERCASE_CC_NAME BEFORE
INSERT
OR UPDATE ON PATS.CONGRESSIONAL_CONTACT FOR EACH ROW
BEGIN
  IF (:old.office_or_person_name IS NULL) OR (:old.office_or_person_name != :new.office_or_person_name) THEN
   :new.upper_case_name := UPPER(:new.office_or_person_name);
  END IF;
 END update_uppercase_cc_name;
/
DROP TRIGGER PATS.UPDATE_ISSUE_CODE_FOR_SORT;

CREATE OR REPLACE TRIGGER PATS.UPDATE_ISSUE_CODE_FOR_SORT BEFORE
INSERT
OR UPDATE ON PATS.ISSUE_CODE FOR EACH ROW
BEGIN
  IF (:old.issue_code IS NULL) OR (:old.issue_code != :new.issue_code)
   THEN
   :new.sort_code := :new.issue_category_fk||SUBSTR(TO_CHAR(TO_NUMBER(SUBSTR(:new.issue_code,3,3)),'009'),2,3);
  END IF;
 END update_issue_code_for_sort;
/
DROP TRIGGER PATS.GENERATE_USER_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_USER_ID BEFORE
INSERT ON PATS.PATS_USER FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.pats_user_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
 END generate_user_id;
/
DROP TRIGGER PATS.GENERATE_TREATMENT_STATUS_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_TREATMENT_STATUS_ID BEFORE
INSERT ON PATS.TREATMENT_STATUS FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.treatment_status_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
END generate_treatment_status_id;
/
DROP TRIGGER PATS.GENERATE_ROC_PHONE_FAX_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_ROC_PHONE_FAX_ID
    BEFORE
INSERT ON PATS.ROC_PHONE_FAX FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.roc_phone_fax_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
END GENERATE_ROC_PHONE_FAX_ID;
/
DROP TRIGGER PATS.GENERATE_ROC_MOC_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_ROC_MOC_ID
    BEFORE
INSERT ON PATS.ROC_METHOD_OF_CONTACT FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.roc_method_of_contact_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
END GENERATE_ROC_MOC_ID;
/
DROP TRIGGER PATS.UPDATE_UPPERCASE_TS_NAME;

CREATE OR REPLACE TRIGGER PATS.UPDATE_UPPERCASE_TS_NAME BEFORE
INSERT
OR UPDATE ON PATS.TREATMENT_STATUS FOR EACH ROW
BEGIN
  IF (:old.treatment_status IS NULL) OR (:old.treatment_status != :new.treatment_status) THEN
   :new.upper_case_name := UPPER(:new.treatment_status);
  END IF;
 END update_uppercase_ts_name;
/
DROP TRIGGER PATS.UPDATE_UPPERCASE_MOC_NAME;

CREATE OR REPLACE TRIGGER PATS.UPDATE_UPPERCASE_MOC_NAME BEFORE
INSERT
OR UPDATE ON PATS.METHOD_OF_CONTACT FOR EACH ROW
BEGIN
  IF (:old.method_of_contact_name IS NULL) OR (:old.method_of_contact_name != :new.method_of_contact_name) THEN
   :new.upper_case_name := UPPER(:new.method_of_contact_name);
  END IF;
 END update_uppercase_moc_name;
/
DROP TRIGGER PATS.UPDATE_UPPERCASE_ISSCODE_NAME;

CREATE OR REPLACE TRIGGER PATS.UPDATE_UPPERCASE_ISSCODE_NAME BEFORE
INSERT
OR UPDATE ON PATS.ISSUE_CODE FOR EACH ROW
BEGIN
  IF (:old.issue_code_name IS NULL) OR (:old.issue_code_name != :new.issue_code_name) THEN
   :new.upper_case_name := UPPER(:new.issue_code_name);
  END IF;
 END update_uppercase_isscode_name;
/
DROP TRIGGER PATS.UPDATE_UPPERCASE_ISSCAT_NAME;

CREATE OR REPLACE TRIGGER PATS.UPDATE_UPPERCASE_ISSCAT_NAME BEFORE
INSERT
OR UPDATE ON PATS.ISSUE_CATEGORY FOR EACH ROW
BEGIN
  IF (:old.issue_category_name IS NULL) OR (:old.issue_category_name != :new.issue_category_name) THEN
   :new.upper_case_name := UPPER(:new.issue_category_name);
  END IF;
 END update_uppercase_isscat_name;
/
DROP TRIGGER PATS.UPDATE_UPPERCASE_HL_NAME;

CREATE OR REPLACE TRIGGER PATS.UPDATE_UPPERCASE_HL_NAME BEFORE
INSERT
OR UPDATE ON PATS.HOSPITAL_LOCATION FOR EACH ROW
BEGIN
  IF (:old.location_name IS NULL) OR (:old.location_name != :new.location_name) THEN
   :new.upper_case_name := UPPER(:new.location_name);
  END IF;
 END update_uppercase_hl_name;
/
DROP TRIGGER PATS.GENERATE_ROC_CE_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_ROC_CE_ID
    BEFORE
INSERT ON PATS.ROC_CONTACTING_ENTITY FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.roc_contacting_entity_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
END GENERATE_ROC_CE_ID;
/
DROP TRIGGER PATS.GENERATE_PATIENT_RACE_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_PATIENT_RACE_ID BEFORE
INSERT ON PATS.PATS_PATIENT_RACE FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.pats_patient_race_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
 END generate_patient_race_id;
/
DROP TRIGGER PATS.GENERATE_NOTIFICATION_MAS_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_NOTIFICATION_MAS_ID BEFORE
INSERT ON PATS.NOTIFICATION_MASTER FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.notification_master_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
 END generate_notification_mas_id;
/
DROP TRIGGER PATS.GENERATE_METHOD_OF_CONTACT_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_METHOD_OF_CONTACT_ID BEFORE
INSERT ON PATS.METHOD_OF_CONTACT FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.method_of_contact_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
 END generate_method_of_contact_id;
/
DROP TRIGGER PATS.GENERATE_FACILITY_SERV_SECT_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_FACILITY_SERV_SECT_ID BEFORE
INSERT ON PATS.FACILITY_SERVICE_OR_SECTION FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
   SELECT pats.facility_serv_or_sect_seq.NEXTVAL
     INTO :new.id
     FROM DUAL;
 END IF;
 END generate_facility_serv_sect_id;
/
DROP TRIGGER PATS.GENERATE_DMLOG_ID;

CREATE OR REPLACE TRIGGER PATS.GENERATE_DMLOG_ID BEFORE
INSERT ON PATS.DMLOG FOR EACH ROW
BEGIN
 IF :new.id IS NULL THEN
    SELECT pats.dmlog_seq.NEXTVAL
      INTO :new.id
      FROM DUAL;
 END IF;
END generate_dmlog_id;
/
